<!DOCTYPE html>
<html lang="en">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
   .container {
      width: 80vw;
      margin: auto;
      overflow: hidden;
   }

   .carousel {
      display: flex;
      transition: transform 0.5s ease-in-out;
   }

   .carousel img {
      max-width: 100%;  /* Adicionado para garantir que a imagem não ultrapasse a largura do contêiner */
      height: auto;
      width: 600px; /* Definindo a largura padrão */
      height: 300px; /* Definindo a altura padrão */
   }

   .carousel-item {
      flex: 0 0 auto;
      width: 100%;
      text-align: center;
      padding: 10px;
      box-sizing: border-box;  /* Adicionado para garantir que o padding não aumente a largura do item */
   }

   .carousel-item p {
      margin: 0;  /* Removido o espaçamento padrão do parágrafo */
      color: white;  /* Cor do texto */
      background: rgba(0, 0, 0, 0.5);  /* Fundo semi-transparente para melhorar a legibilidade */
      padding: 10px;  /* Espaçamento interno do texto */
   }
</style>

</head>
<body style="background: transparent;">
   <div class="container">
      <div class="carousel" id="myCarousel">
         <?php
            // Sample data with PNG images and absolute URLs
            $data = [
               ['ImageUrl' => 'https://vod.brott.xyz/smarters/logo/custom_name.png', 'AdditionalText' => 'BEM VINDO'],
               ['ImageUrl' => 'https://vod.brott.xyz/smarters/logo1/custom_name1.png', 'AdditionalText' => 'TESTE APP'],
               ['ImageUrl' => 'https://vod.brott.xyz/smarters/logo2/custom_name2.png', 'AdditionalText' => 'Faça Seu Login'],
            ];

            foreach ($data as $item) {
               $imageUrl = $item['ImageUrl'];
               $additionalText = $item['AdditionalText'];

               echo "<div class='carousel-item'>";
               echo "<img src='$imageUrl' alt='Image'/>";
               echo "<p>$additionalText</p>";
               echo "</div>";
            }
         ?>
      </div>
   </div>

   <script>
      var currentIndex = 0;
      var totalItems = <?php echo count($data); ?>;
      var items = document.querySelectorAll('.carousel-item');
      var carousel = document.getElementById('myCarousel');

      function nextSlide() {
         currentIndex = (currentIndex + 1) % totalItems;
         var transformValue = -currentIndex * 100 + '%';
         carousel.style.transform = 'translateX(' + transformValue + ')';
      }

      setInterval(nextSlide, 5000); // Change slide every 5 seconds (adjust as needed)
   </script>
</body>
</html>
