<!DOCTYPE html>
<html lang="en">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <style>
      .container {
         height: 100vh;
         width: 100vw;
         position: relative;
      }

      .center {
         position: absolute;
         top: 50%;
         left: 50%;
         transform: translate(-50%, -50%);
         max-width: 80vw;
         max-height: 80vh;
         animation: flipImage 5s infinite linear; /* Adjust the duration and animation type as needed */
      }

      @keyframes flipImage {
         from {
            transform: translate(-50%, -50%) rotateY(0deg);
         }
         to {
            transform: translate(-50%, -50%) rotateY(360deg);
         }
      }
   </style>
</head>
<body style="background: transparent;">
   <div class="container">
      <?php
         // Read the JSON file content
         $jsonData = file_get_contents('../logo/filenames.json');
         
         // Decode the JSON data
         $data = json_decode($jsonData, true);
         
         // Check if decoding was successful
         if ($data !== null) {
            // Loop through each item in the array
            foreach ($data as $item) {
               // Retrieve ImageName and Upload_type values
               $imageName = $item['ImageName'];
               $uploadType = $item['Upload_type'];
            
            if($uploadType == 'by_file'){
            	echo "<img class='center' src='../logo/$imageName' alt='Flipping Image'/>";
            }else if ($uploadType == 'by_url'){
           		 echo "<img class='center' src='$imageName' alt='Flipping Image'/>";
            }else{
            	echo "<img class='center' src='loginlogo.png$imageName' alt='Flipping Image'/>";
            }
            
            	
               // Output the values
               
            }
         } else {
            // Handle JSON decoding error
            echo "Error decoding JSON\n";
         }
      ?>
   </div>
</body>
</html>
